﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "benchmark_task.h"
#if ENABLE_BENCHMARK_TESTING
//==============================================================================
namespace tma { namespace benchmark {
//==============================================================================

//==============================================================================

BenchmarkTask::BenchmarkTask()
{
//NN_SDK_LOG( "[BenchmarkTask::BenchmarkTask( 0x%p )]\n", this );
    m_TaskType = tmipc::TaskType_BenchmarkTask;
}

//==============================================================================

BenchmarkTask::~BenchmarkTask()
{
//NN_SDK_LOG( "[BenchmarkTask::~BenchmarkTask( 0x%p )]\n", this );
}

//==============================================================================

void BenchmarkTask::OnInitiate( tmipc::Packet* pPacket )
{
    s32 Result = 0;

    // Fill in the return packet.
    tmipc::Packet* pReturnPacket = AllocSendPacket();
    m_pServicesManager->Send( pReturnPacket );

    // Task complete.
    Complete();
}

//==============================================================================

void BenchmarkTask::OnRecvPacket( tmipc::Packet* pPacket )
{
    // No processing, just complete the task on a packet.
    (void)pPacket;
    Complete();
}

//==============================================================================

void BenchmarkTask::OnSendPacket( tmipc::Packet* pPacket )
{
    // TODO - Handle Packet
    (void)pPacket;
    ASSERT( 0 );
}

//==============================================================================
}}
//==============================================================================

#endif // ENABLE_BENCHMARK_TESTING
