﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/time/time_StandardLocalSystemClockPrivilegeApi.h>

#include <nn/time/detail/time_CommonDetail.h>
#include <nn/timesrv/detail/service/timesrv_IStaticService.sfdl.h>

namespace nn
{
namespace time
{

extern nn::sf::SharedPointer<nn::timesrv::detail::service::IStaticService> g_pStaticService;

// Admin権限がないと成功しない特権API
Result SetStandardLocalSystemClockCurrentTime(const PosixTime& posixTime) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(g_pStaticService != nullptr, ResultNotInitialized());

    // LocalClock サービスオブジェクトはここでしか利用しないので都度作って破棄する
    nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock> pClock = nullptr;
    NN_RESULT_DO(g_pStaticService->GetStandardLocalSystemClock(&pClock));

    NN_RESULT_DO(pClock->SetCurrentTime(posixTime));

    NN_RESULT_SUCCESS;
}

// Admin権限がないと成功しない特権API
Result SetStandardLocalSystemClockContext(const SystemClockContext& clockContext) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(g_pStaticService != nullptr, ResultNotInitialized());

    // LocalClock サービスオブジェクトはここでしか利用しないので都度作って破棄する
    nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock> pClock = nullptr;
    NN_RESULT_DO(g_pStaticService->GetStandardLocalSystemClock(&pClock));

    NN_RESULT_DO(pClock->SetSystemClockContext(clockContext));

    NN_RESULT_SUCCESS;
}


}
}

