﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/time/detail/time_TimeZonePrivateApi.h>
#include <nn/timesrv/detail/service/timesrv_ITimeZoneService.sfdl.h>

namespace nn { namespace time {

extern nn::sf::SharedPointer<nn::timesrv::detail::service::ITimeZoneService> g_pTimeZoneService;

namespace detail {

void GetDeviceLocationNameAndUpdatedTime(
    nn::time::LocationName* pOutLocationName,
    nn::time::SteadyClockTimePoint* pOutUpdatedTime) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutLocationName);
    NN_SDK_REQUIRES_NOT_NULL(pOutUpdatedTime);
    NN_ABORT_UNLESS(g_pTimeZoneService != nullptr, "[TIME] The time library is not initialized.");

    NN_ABORT_UNLESS_RESULT_SUCCESS(
        g_pTimeZoneService->GetDeviceLocationNameAndUpdatedTime(pOutLocationName, pOutUpdatedTime));
}

}}}
