﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>

#include <nn/os/os_SystemEvent.h>
#include <nn/tc/tc.h>
#include <nn/tcap/tcap_OperationModeTypes.h>

#include "tcap_ContinuousHighSkinTemperatureHandler.h"
#include "tcap_SettingsHolder.h"

namespace nn { namespace tcap { namespace server {

class ThermalCoordinatorAdvancedPolicy final
{
    NN_DISALLOW_COPY(ThermalCoordinatorAdvancedPolicy);
    NN_DISALLOW_MOVE(ThermalCoordinatorAdvancedPolicy);

public:
    ThermalCoordinatorAdvancedPolicy() NN_NOEXCEPT
        : m_ContinuousHighSkinTemperatureHandler(28800000)
        , m_SettingsHolder()
    {
        m_SettingsHolder.LoadSettings();
        m_ContinuousHighSkinTemperatureHandler.Initialize(m_SettingsHolder.GetContinuousHighSkinTemperatureMilliSeconds());
    }

    void Update(nn::TimeSpan elapsedTime) NN_NOEXCEPT;
    void ClearElapsedTime() NN_NOEXCEPT;
    nn::os::SystemEventType* GetContinuousHighSkinTemperatureEvent() NN_NOEXCEPT;
    void SetOperationMode(OperationMode operationMode) NN_NOEXCEPT;
    void LoadAndApplySettings() NN_NOEXCEPT;

private:
    ContinuousHighSkinTemperatureHandler m_ContinuousHighSkinTemperatureHandler;

    SettingsHolder m_SettingsHolder;
};

ThermalCoordinatorAdvancedPolicy& GetThermalCoordinatorAdvancedPolicy() NN_NOEXCEPT;

}}} // namespace nn::tcap::server
