﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fan/fan.h>
#include <nn/tc/tc_Types.h>
#include <nn/tc/impl/tc_PowerModeTypes.h>

#include "tc_SettingsHolder.h"

namespace nn { namespace tc { namespace impl { namespace detail {

class ThermalHandler {

private:
    enum class TemperaturePolicy
    {
        Handheld,
        Console,
    };

public:
    ThermalHandler()
    : m_OperatingMode(OperatingMode_Handheld)
    , m_Controller()
    , m_FanControlEnabled(true)
    , m_PowerMode(PowerMode_FullAwake)
    , m_SpeedLevelFromTable(0)
    , m_SpeedLevelFromPrev(0)
    , m_pSettingsHolder(nullptr)
    , m_PreviousPolicy(TemperaturePolicy::Handheld)
    , m_TemperatureLevelIndex(0)
    {
    }

    void Initialize(SettingsHolder* pSettingsHolder) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void SetTemperature(TemperatureMilliC skinTemperature, TemperatureMilliC pcbTemperature, TemperatureMilliC socTemperature) NN_NOEXCEPT;
    void SetOperatingMode(OperatingMode operatingMode) NN_NOEXCEPT;
    void SetFanControlEnabled(bool enabled) NN_NOEXCEPT;
    bool GetFanControlEnabled() NN_NOEXCEPT;
    void SetPowerMode(PowerMode powerMode) NN_NOEXCEPT;
    nn::fan::RotationSpeedLevel GetRotationSpeedLevel(RateSelect rateSelect) NN_NOEXCEPT;
    nn::fan::RotationSpeedLevel GetFanRotationSpeedLevel() NN_NOEXCEPT;
    nn::fan::RotationSpeedLevel GetFanActualRotationSpeedLevel() NN_NOEXCEPT;

private:
    int GetNumberOfTemperatureLevel(TemperaturePolicy policy) NN_NOEXCEPT;
    const TemperatureLevel& GetTemperatureLevel(TemperaturePolicy policy, int index) NN_NOEXCEPT;
    nn::fan::RotationSpeedLevel GetRotationSpeedLevelFromTable(TemperatureMilliC temperatureMilliC) NN_NOEXCEPT;

private:
    OperatingMode m_OperatingMode;
    nn::fan::Controller m_Controller;
    bool m_FanControlEnabled;
    PowerMode m_PowerMode;
    nn::fan::RotationSpeedLevel m_SpeedLevelFromTable;
    nn::fan::RotationSpeedLevel m_SpeedLevelFromPrev;
    SettingsHolder* m_pSettingsHolder;

    //! 参照する温度レベルテーブルを表す値
    TemperaturePolicy m_PreviousPolicy;

    //! 現在の温度レベルを示すインデックス
    int m_TemperatureLevelIndex;
};

}}}} // namespace nn::tc::impl::detail
