﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_SdkLog.h>
#include <nn/ssl/detail/ssl_Common.h>
#include <nn/ssl/detail/ssl_Build.h>
#include <nn/ssl/detail/ssl_Log.h>
#include <nn/ssl/ssl_Types.h>

#define NN_DETAIL_SSL_WARN_PRINT(...)                                                             \
    do{                                                                                           \
    NN_DETAIL_SSL_WARN(" ssl: " __VA_ARGS__);                                                     \
    } while (NN_STATIC_CONDITION(false))

#define NN_DETAIL_SSL_INFO_PRINT(...)                                                             \
    do{                                                                                           \
    NN_DETAIL_SSL_INFO(" ssl: " __VA_ARGS__);                                                     \
    } while (NN_STATIC_CONDITION(false))

// ------------------------------------------------------------------------------------------------
// Debug log utils
// ------------------------------------------------------------------------------------------------
#ifdef NN_DETAIL_SSL_ENABLE_DEBUG_PRINT
#define NN_DETAIL_SSL_DBG_PRINT(...)                                                              \
    do {                                                                                          \
        NN_DETAIL_SSL_TRACE(" ssl:" __VA_ARGS__);                                                 \
    }while(NN_STATIC_CONDITION(false))

#define NN_DETAIL_SSL_DBG_PRINT_RAW(...)                                                          \
    do {                                                                                          \
        NN_DETAIL_SSL_TRACE(__VA_ARGS__);                                                         \
    }while(NN_STATIC_CONDITION(false))

#define NN_DETAIL_SSL_DBG_PRINT_HEX_TABLE(pData,len)                                              \
    do {                                                                                          \
    char           tmpBuf[17 * 3 + 1];                                                            \
    char           *cur = tmpBuf;                                                                 \
    unsigned char* pChar = reinterpret_cast<unsigned char*>(pData);                               \
    NN_UNUSED(pChar);                                                                             \
    NN_UNUSED(tmpBuf);                                                                            \
    NN_UNUSED(cur);                                                                               \
    for (uint32_t _phti = 0; _phti < len; _phti++)                                                \
    {                                                                                             \
        if ((_phti != 0) && ((_phti % 16) == 0))                                                  \
        {                                                                                         \
            sprintf(cur, "\n");                                                                   \
            NN_DETAIL_SSL_DBG_PRINT(" %s", tmpBuf);                                               \
            cur = tmpBuf;                                                                         \
        }                                                                                         \
        cur += sprintf(cur, "%2.2X ", pChar[_phti]);                                              \
    }                                                                                             \
    if (cur != tmpBuf)                                                                            \
    {                                                                                             \
        sprintf(cur, "\n");                                                                       \
        NN_DETAIL_SSL_DBG_PRINT(" %s", tmpBuf);                                                   \
    }                                                                                             \
} while (NN_STATIC_CONDITION(false))

#else

#define NN_DETAIL_SSL_DBG_PRINT(format, ...)
#define NN_DETAIL_SSL_DBG_PRINT_RAW(format, ...)
#define NN_DETAIL_SSL_DBG_PRINT_HEX_TABLE(pData,len)
#define NN_DETAIL_SSL_DUMP_NSS_VERSION()

#endif // NN_DETAIL_SSL_ENABLE_DEBUG_PRINT

#if defined(NN_DETAIL_SSL_DBG_PRINT_CERTSTORE)
#define NN_DETAIL_SSL_DBG_CERTSTORE_PRINT(...)                                                    \
    do {                                                                                          \
        NN_DETAIL_SSL_TRACE(" ssl[Certstore] " __VA_ARGS__);                                      \
    }while(NN_STATIC_CONDITION(false))

#define NN_DETAIL_SSL_DBG_CERTSTORE_PRINT_RAW(...)                                                \
    do {                                                                                          \
        NN_DETAIL_SSL_DBG_PRINT_RAW(__VA_ARGS__);                                                 \
    }while(NN_STATIC_CONDITION(false))
#else
#define NN_DETAIL_SSL_DBG_CERTSTORE_PRINT(...)
#define NN_DETAIL_SSL_DBG_CERTSTORE_PRINT_RAW(...)
#endif // NN_DETAIL_SSL_DBG_PRINT_CERTSTORE

#define NN_DETAIL_SSL_PRINT_CERT_INFO(...)                                                        \
    do {                                                                                          \
        NN_DETAIL_SSL_DBG_PRINT_RAW(__VA_ARGS__);                                                 \
    }while(NN_STATIC_CONDITION(false))

#ifdef NN_DETAIL_SSL_ENABLE_DEBUG_PRINT_IO
#define NN_DETAIL_SSL_DBG_PRINT_IO(...)                                                           \
    do {                                                                                          \
        NN_DETAIL_SSL_TRACE(" ssl[I/O]: " __VA_ARGS__);                                           \
    }while(NN_STATIC_CONDITION(false))
#else
#define NN_DETAIL_SSL_DBG_PRINT_IO(format, ...)
#endif // NN_DETAIL_SSL_ENABLE_DEBUG_PRINT_IO

#define NN_DETAIL_SSL_BREAK_ON_NSS_FAILURE(operation)                                            \
    if(operation != SECSuccess)                                                                  \
    {                                                                                            \
        break;                                                                                   \
    }

#define NN_DETAIL_SSL_VALIDATE_SHARED_POINTER(ptr, result, errResult) \
    if ((ptr == nullptr) || (*ptr == nullptr))                        \
    {                                                                 \
        result = errResult;                                           \
        break;                                                        \
    }

#define NN_DETAIL_SSL_EXPAND_32_TO_64(dst, src)               \
    dst = static_cast<uint64_t>((static_cast<uint64_t>((src) & 0xFF000000) << 24) | \
                                (static_cast<uint64_t>((src) & 0x00FF0000) << 16) | \
                                (static_cast<uint64_t>((src) & 0x0000FF00) << 8)  | \
                                (static_cast<uint64_t>((src) & 0x000000FF)))

#define NN_DETAIL_SSL_SHRINK_64_TO_32(dst, src)                        \
    dst = static_cast<uint32_t>(((src & 0x00FF000000000000L) >> 24) | \
                                ((src & 0x000000FF00000000L) >> 16) | \
                                ((src & 0x0000000000FF0000L) >> 8)  | \
                                ((src & 0x00000000000000FFL)))

//  Simple 2-way bit manipulation to obfuscate the real value
#define NN_DETAIL_SSL_MIX_64BIT(src)       \
    (((src & 0xFFFF000000000000L) >> 48) | \
     ((src & 0x0000FFFF00000000L) >> 16) | \
     ((src & 0x00000000FFFF0000L) << 16) | \
     ((src & 0x000000000000FFFFL) << 48))

#ifdef NN_BUILD_CONFIG_ADDRESS_64

#define NN_DETAIL_SSL_GET_ID_FROM_PTR(id, ptr)         \
    do                                                 \
    {                                                  \
        uint64_t tmp;                                  \
        tmp = reinterpret_cast<uint64_t>(ptr);         \
        id = NN_DETAIL_SSL_MIX_64BIT(tmp);             \
    } while (NN_STATIC_CONDITION(false));

#define NN_DETAIL_SSL_GET_PTR_FROM_ID(ptr, id, type)  \
    do                                                \
    {                                                 \
        uint64_t tmp;                                 \
        tmp = NN_DETAIL_SSL_MIX_64BIT(id);            \
        ptr = reinterpret_cast<type *>(tmp);          \
    } while (NN_STATIC_CONDITION(false));

#else

#define NN_DETAIL_SSL_GET_ID_FROM_PTR(id, ptr)         \
    do                                                 \
    {                                                  \
        uint64_t tmp;                                  \
        uint32_t tmp32;                                \
        tmp32 = reinterpret_cast<uint32_t>(ptr);       \
        NN_DETAIL_SSL_EXPAND_32_TO_64(tmp, tmp32);     \
        id = NN_DETAIL_SSL_MIX_64BIT(tmp);             \
    } while (NN_STATIC_CONDITION(false));

#define NN_DETAIL_SSL_GET_PTR_FROM_ID(ptr, id, type)  \
    do                                                \
    {                                                 \
        uint64_t tmp;                                 \
        tmp = NN_DETAIL_SSL_MIX_64BIT(id);            \
        uint32_t tmp32;                               \
        NN_DETAIL_SSL_SHRINK_64_TO_32(tmp32, tmp);    \
        ptr = reinterpret_cast<type *>(tmp32);        \
    } while (NN_STATIC_CONDITION(false));

#endif    //  NN_BUILD_CONFIG_ADDRESS_64

#ifdef NN_BUILD_CONFIG_OS_WIN
#define NN_DETAIL_SSL_SNPRINTF _snprintf
#else
#define NN_DETAIL_SSL_SNPRINTF snprintf
#endif // NN_BUILD_CONFIG_OS_WIN

// ------------------------------------------------------------------------------------------------
// nn::ssl::detail
// ------------------------------------------------------------------------------------------------
namespace nn { namespace ssl { namespace detail {


class Util
{
public:
    static const uint32_t       g_NumCharsUint64Hex = 16;

    static nn::Result ConvertResultFromInternalToExternal(nn::Result result);
    static bool IsInitializeForTestEnabled();
};


}}}
