﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/fs/fs_File.h>
#include <nn/fs/fs_FileSystem.h>
#include <nn/fs/fs_Mount.h>
#include <nn/fs/fs_SystemData.h>

#include <nn/ssl/detail/ssl_Common.h>
#include "ssl_BdfReader.h"

namespace nn { namespace ssl { namespace detail {

//////////////////////////////////////////////////////////////////////////////
//  SystemDataReader - BDF data reader based on BDF located in SystemData.
//////////////////////////////////////////////////////////////////////////////
class SystemDataReader : public BdfReader
{
private:
    static const char                               *g_TrustedCertMountPoint;
    static const char                               *g_TcfName;
    static const char                               *g_CrlName;
    static const char                               *g_TestCrlName;
    static const nn::ncm::SystemDataId              g_SslTrustedCertManagerId;
    static const size_t                             g_ScratchBufSize = 512;
    static uint8_t                                  *g_pCacheBuf;

    BdfReader::BdfId                                m_id;
    nn::fs::FileHandle                              m_File;

    static bool IsInitialized();

public:
    explicit SystemDataReader(BdfReader::BdfId id);
    ~SystemDataReader();

    static nn::Result Initialize();
    static nn::Result Finalize();

    virtual nn::Result Open() NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result Read(size_t   *pOutBytesRead,
                            int64_t  offset,
                            uint8_t  *pOutBuf,
                            size_t   size) NN_NOEXCEPT NN_OVERRIDE;
};

} } }    //  nn::ssl::detail
