﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/os.h>
#include <nn/sf/sf_HipcSimpleAllInOneServerManager.h>

#include "detail/ssl_ServiceSession.h"
#include "server/ssl_Util.h"

using namespace nn::os;
using namespace nn::sf;

//  Forward declaration to avoid compiler problems with SSL process
extern "C"
{
typedef struct PRThread PRThread;
}

namespace nn { namespace ssl { namespace detail {

const char SslServiceSessionName[] = "ssl";

class SslServiceManagerLimits
{
public:
    static const uint32_t       g_MaxServerSessions = 64;
};

struct SslServiceManagerOption
{
    static const int SubDomainCountMax = 32;
    static const int ObjectInSubDomainCountMax = MaxContextCount * MaxConnectionCount;
};

class SslServiceManager : HipcSimpleAllInOneServerManager<SslServiceManagerLimits::g_MaxServerSessions,
                                                          ServiceSession::g_SessionPorts,
                                                          SslServiceManagerOption>
{
private:
    static const uint32_t       g_SessionThreadStackSize = 1024 * 64;
    static const uint32_t       g_SessionThreadCount = 5;
#ifdef USE_NNOS_THREAD_DIRECT
    ThreadType                  m_SessionThreads[g_SessionThreadCount];
    uint8_t                     *m_SessionThreadAlloc[g_SessionThreadCount];
    uint8_t                     *m_SessionThreadStack[g_SessionThreadCount];
#else
    PRThread                    *m_SessionThreads[g_SessionThreadCount];
#endif

    virtual nn::Result OnNeedsToAccept(int portIndex, PortForAllInOne *pPort) NN_NOEXCEPT;
    static void SessionThreadEntry(void *arg) NN_NOEXCEPT;

public:
    SslServiceManager();
    ~SslServiceManager();

    nn::Result Initialize();
    nn::Result Finalize();

    int GetSessionThreadCount()
    {
        return static_cast<int>(g_SessionThreadCount);
    }
};

} } }
