﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/os/os_Mutex.h>
#include <nn/ssl/detail/ssl_ISslService.h>

#include "server/ssl_SslSfObservable.h"


using namespace nn::sf;
using namespace nn::ssl::sf;

namespace nn { namespace ssl { namespace detail {

class SslContextImpl;

class SslServiceImpl : public ISharedObject,
                       public SslSfObservable
{
private:
    nn::Bit64                               m_ClientProcessId;
    uint32_t                                m_ISslServiceVersion;

    nn::Result GetCertificateBufSize(uint32_t        *pOutSize,
                                     bool            *pOutAll,
                                     const uint32_t  *pIds,
                                     uint32_t        idCount);
    nn::Result GetAllIds(uint32_t **pOutIds, uint32_t *pOutNumIds);

public:
    SslServiceImpl() NN_NOEXCEPT;
    ~SslServiceImpl() NN_NOEXCEPT;

    nn::Result CreateContext(Out<SharedPointer<ISslContext>>  outContext,
                             SslVersion                       version,
                             nn::Bit64                        processId) NN_NOEXCEPT;

    nn::Result GetContextCount(Out<uint32_t> outValue) NN_NOEXCEPT;

    nn::Result GetCertificates(const OutBuffer  &outCertsData,
                               Out<uint32_t>    outIdCount,
                               const InBuffer   &inCertIds);

    nn::Result GetCertificateBufSize(Out<uint32_t>   outSize,
                                     const InBuffer  &inCertIds);

    nn::Bit64 GetClientProcessId() NN_NOEXCEPT;

    nn::Result SetInterfaceVersion(uint32_t inValue) NN_NOEXCEPT;
    uint32_t GetInterfaceVersion() NN_NOEXCEPT;

    nn::Result FlushSessionCache(Out<uint32_t> outEntriesDeletedCount, InBuffer inHostName, nn::ssl::sf::FlushSessionCacheOptionType option) NN_NOEXCEPT;

    // ------------------------------------------------------------------------
    // Debug interface
    // ------------------------------------------------------------------------
    nn::Result DebugIoctl(const OutBuffer &outData,
                          const InBuffer  &inData,
                          uint64_t cmd) NN_NOEXCEPT;
};

} } }
