﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/os.h>

#include <nn/ssl/ssl_Context.h>
#include <nn/ssl/detail/ssl_ISslContext.h>
#include <nn/ssl/detail/ssl_ISslConnection.h>

#include "server/ssl_SslSfObservable.h"
#include "server/ssl_SslServiceImpl.h"
#include "server/ssl_CertStore.h"
#include "server/ssl_EvCertUtil.h"


using namespace nn::sf;
using namespace nn::ssl::sf;

namespace nn { namespace ssl { namespace detail {

//  Forward declaration
class SslConnectionImpl;

class SslContextImpl : public nn::sf::ISharedObject,
                       public SslSfObservable
{
private:
    nn::sf::SharedPointer<SslServiceImpl>   m_Parent;
    int32_t                                 m_SslVersion;
    CertStore                               m_CertStore;
    EvCertUtil::PolicyOidInfo               m_PolicyOidInfo;
    bool                                    m_CrlDateCheckEnabled;

public:
    SslContextImpl(SslServiceImpl *parent, int32_t sslVersion) NN_NOEXCEPT;
    ~SslContextImpl() NN_NOEXCEPT;

    SslServiceImpl *GetParentSslService();
    nn::ssl::Context::SslVersion GetSslVersion();
    CertStore *GetCertStore();
    EvCertUtil::PolicyOidInfo* GetPolicyOidInfo();
    bool IsCrlDateCheckEnabled();

    nn::Result SetOption(ContextOption option, int32_t value) NN_NOEXCEPT;
    nn::Result GetOption(Out<int32_t> outValue, ContextOption option) NN_NOEXCEPT;

    nn::Result ImportServerPki(Out<uint64_t> outCertId, InBuffer inCertData, nn::ssl::sf::CertificateFormat fmt);
    nn::Result ImportClientPki(Out<uint64_t> outCertId, InBuffer inP12Data, InBuffer inPwData);
    nn::Result RemoveServerPki(uint64_t certId);
    nn::Result RemoveClientPki(uint64_t certId);
    nn::Result RegisterInternalPki(Out<uint64_t> outCertId, InternalPki sfPki);
    nn::Result AddPolicyOid(const InBuffer& stringBuffer) NN_NOEXCEPT;
    nn::Result ImportCrl(Out<uint64_t> outCrlId, InBuffer inCrlData) NN_NOEXCEPT;
    nn::Result RemoveCrl(uint64_t crlId) NN_NOEXCEPT;

    nn::Result CreateConnection(Out<SharedPointer<ISslConnection>> outValue) NN_NOEXCEPT;
    nn::Result GetConnectionCount(Out<uint32_t> outValue) NN_NOEXCEPT;

    //  Observer implementation for cleaning up SslConnectionImpl from the set
    void OnDestroy(SslSfObservable *object);
};

} } }
