﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ssl/detail/ssl_Build.h>
#include <nn/ssl/ssl_Types.h>

#include "ssl_NssCommon.h"

namespace nn { namespace ssl { namespace detail {

typedef struct CertDecoderDetailStr
{
    CERTCertificate             *pCert;
    const char                  *pNickname;
} CertDecoderDetail;


typedef struct Pk12ImportDetailsStr
{
    const char                  *pInP12Data;
    const char                  *pInPwData;
    uint32_t                    p12DataLen;
    uint32_t                    pwDataLen;
} Pk12ImportDetails;


typedef struct Pk12RenameDetailsStr
{
    SECItem                     *pDerCert;
    char                        *pNickname;
} Pk12RenameDetails;


class Pk12ModuleUtil
{
private:
    static SECStatus FindExistingPrivKeyAndCert(PK11SlotInfo      *pSlot,
                                                SECItem           *pDerCert,
                                                CERTCertificate   **pCert,
                                                SECKEYPrivateKey  **pKey);

    static SECItem *FindDERCertForPrivKey(SEC_PKCS12DecoderContext *pCtx);

public:
    static SECItem* CallbackP12NicknameCollision(SECItem* pInOldNickname,
                                                 PRBool*  pIsCancel,
                                                 void*    pArg);
    static SECStatus CallbackP12NicknameRename(const CERTCertificate*  cert,
                                               const SECItem*          defaultNickname,
                                               SECItem**               newNickname,
                                               void*                   arg);

    static SECStatus ProcessP12Data(PK11SlotInfo      *pInPk11Slot,
                                    SECItem           *pInPassword,
                                    SECItem           *p12File,
                                    char              *pInOutNickname,
                                    uint32_t          maxNicknameLen,
                                    CERTCertificate   **pOutCert,
                                    SECKEYPrivateKey  **pOutPrivKey);

    static SECItem* PrepPassword(const char *pInPasswordData, uint32_t passwordDataSize);
};


class Pk11ModuleUtil
{
private:
    static SECStatus DecodeCertCb(void     *pArg,
                                  SECItem  **pCertItems,
                                  int      certsCount);

    static SECStatus SslCertTraverseCb(CERTCertificate *pCert,
                                       void            *arg);

public:
    static nn::Result CheckAndSetupDefaultSlot();

    static nn::Result ImportPk12(Pk12ImportDetails *pInDetails,
                                 char              *pInOutNickname,
                                 uint32_t          maxNameLen,
                                 CERTCertificate   **pOutCert,
                                 SECKEYPrivateKey  **pOutPrivKey);

    static nn::Result GetClientPki(const char       *pInNickname,
                                   CERTCertificate  **pOutCert,
                                   SECKEYPrivateKey **pOutPrivKey);

    static void DumpSlotInformation();
};

}}}
