﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nnc/os.h>
#include <nn/init.h>

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus

#include "nspr.h"
#include "prtypes.h"
#include "plstr.h"
#include "private/pprio.h" // PR_ImportTCPSocket

#include "nss.h"
#include "pk11pub.h"
#include "ssl.h"
#include "nnsdk_fsHelper.h"

#include "keyhi.h"    // SECKEY_EncodeDERSubjectPublicKeyInfo
#include "cert.h"     // CERT_NewTempCertificate
#include "certdb.h"   // SEC_DeletePermCertificate
#include "secitem.h"  // SECITEM_*
#include "secmod.h"   // SECMOD_AddNewModuleEx
#include "secerr.h"   // SEC_ERROR_*
#include "sslerr.h"   // SSL_ERROR_*

#include "prprf.h"
#include "p12.h"

#include "base64.h"   // ATOB_ConvertAsciiToItem
#include "p12plcy.h"
#include "ciferfam.h"
#include "secutil.h"

#include "nnsdk_NssPort.h"

#include "pkcs11.h"
#include "secmodi.h"

#include "pkix_pl_system.h"
#include "pkix_error.h"
#include "libpkix/nnsdk_pkix_pl_system.h"    //  NSS PKIX layer for purging hash tables

#include "sslproto.h"
#ifdef __cplusplus
}
#endif // __cplusplus
