﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_SdkLog.h>

#include <nn/settings/factory/settings_Ssl.h>

#include <nn/ssl/ssl_Context.h>
#include <nn/ssl/detail/ssl_Common.h>
#include <nn/ssl/detail/ssl_Build.h>
#include <nn/ssl/ssl_Types.h>

#include "server/ssl_NssUtil.h"
#include "server/ssl_NssConfigurator.h"
#include "server/ssl_NssPkcsUtil.h"
#include "server/ssl_NssCommon.h"

#define BREAK_ON_FAILURE(result) \
do { \
    if(result.IsFailure()) \
    { \
        break; \
    } \
} while(NN_STATIC_CONDITION(false))

namespace nn { namespace ssl { namespace detail {

// ------------------------------------------------------------------------------------------------
// class InternalPkiManager
// ------------------------------------------------------------------------------------------------
class InternalPkiManager
{
private:

#if defined(NN_BUILD_CONFIG_OS_WIN)
    static const char*          g_PsuedoCertPath;
    static const char*          g_PsuedoPasswordPath;
    static const char*          g_MountName;
    static const char*          g_pDevicePkiLabel;

    static nn::Result ReadFileContents(const char *path,
                                       char       **pOutBuf,
                                       uint32_t   *pOutLen);
    static nn::Result ReadFromExternal(char      **pOutCertData,
                                       uint32_t  *pOutCertLen,
                                       char      **pOutPwData,
                                       uint32_t  *pOutPwLen);
    static nn::Result ReadAndImportFromSdCard();
#endif

    static SECMODModule*        g_pMod;
    static PK11SlotInfo*        g_pSlot;

public:
    static const char* GetNickname(nn::ssl::Context::InternalPki pkiType);
    static nn::Result CheckAndInstallIfNeeded();
    static PK11SlotInfo* GetPk11Slot();
};

}}}
