﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "detail/ssl_ISslServiceDfcFactory.h"
#include "server/ssl_MemoryManager.h"
#include "server/ssl_ServiceDatabase.h"

namespace nn { namespace ssl { namespace detail {


nn::Result ISslServiceDfcFactory::CreateISslService(SharedPointer<ISslService> *pOut) NN_NOEXCEPT
{
    nn::Result                  ret = nn::ResultSuccess();

    do
    {
        //  Create a new instance of the top level SSL service object and the SF
        //  interface wrapper.  This will be provided to the caller via SharedPointer.
        EmplacedRef<ISslService, SslServiceImpl> er =
            SfObjFactory::CreateSharedEmplaced<ISslService,
                                               SslServiceImpl>(SslMemoryManager::GetSfAllocator());
        SslServiceImpl &impl = er.GetImpl();
        ret = SslServiceDatabase::AddSslService(&impl);
        if (ret.IsFailure())
        {
            //  We failed to add it to the database, usually means that we have
            //  hit a limit (max clients).  Null out the SharedPointer so the
            //  instance is destroyed then bail out.
            SharedPointer<ISslService> throwAway = er;
            throwAway = nullptr;
            break;
        }

        //  We have successfully created an instance, give it to the caller
        //  and pop out.
        *pOut = er;
    } while (NN_STATIC_CONDITION(false));

    return ret;
}

} } }
