﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_SdkLog.h>
#include <nn/ssl/detail/ssl_Common.h>
#include <nn/ssl/detail/ssl_Build.h>
#include <nn/ssl/detail/ssl_Log.h>
#include <nn/ssl/ssl_Types.h>

#include "ssl_DebugUtil.h"

// ------------------------------------------------------------------------------------------------
// SSL debug shell
//
// The debug shell in the SSL process is implemented in nn::ssl::DebugShell. It uses the UDP as a
// communication channel.
//
// The SSL process creates a UDP socket and binds it to port DebugShell::ServerPort. A sender of
// the command (e.g. Windows PC) is supposed to send a command to this port in a form of UDP
// datagram. Note that this communication is backed by the network connection on Horizon (USB-Eth
// wired connection or WiFi), not a connection though the host bridge.
//
// Please refer ssl_DebugShell.cpp for supported commands or send "help" command to the shell.
// ------------------------------------------------------------------------------------------------

namespace nn { namespace ssl { namespace detail {
    class DebugShell
    {
        static const int ThreadStackSize = (nn::os::StackRegionAlignment < 4096)?(4096):(nn::os::StackRegionAlignment);
        static const int ServerPort      = 6000;

        NN_ALIGNAS(nn::os::StackRegionAlignment) char m_ThreadStack[ThreadStackSize];
        nn::os::ThreadType m_Thread;

        static void Executer(void* arg) NN_NOEXCEPT;

    public:
        DebugShell() NN_NOEXCEPT;
        ~DebugShell() NN_NOEXCEPT;

        bool Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;
    };

    extern DebugShell g_DebugShellManager;
}}}
