﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_Common.h>
#include <nn/gpio/gpio.h>
#include <nn/spsm/spsm_PowerStateTypes.h>

namespace nn { namespace spsm { namespace server {

    void IntializeWakeReason() NN_NOEXCEPT;

    // -------------------------------------------------------------------------------------
    // アグリゲートされたウェイク要因フラグの取得

    void RequireUpdateWakeReasonFlagSet(bool require) NN_NOEXCEPT;
    void UpdateWakeReasonFlagSet() NN_NOEXCEPT;
    WakeReasonFlagSet GetWakeReasonFlagSet() NN_NOEXCEPT;
    void SetWakeReasonFlagSet(const WakeReasonFlagSet& flagSet) NN_NOEXCEPT;

#if defined(NN_BUILD_CONFIG_OS_WIN)
    void SetEmulatedWakeReasonFlagSet(const WakeReasonFlagSet& flagSet) NN_NOEXCEPT;
#endif

}}}

