﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>

namespace nn { namespace spsm { namespace server {

    class SettingsHolder
    {
        NN_DISALLOW_COPY(SettingsHolder);
        NN_DISALLOW_MOVE(SettingsHolder);

    private: // Singleton
        SettingsHolder() = default;

    public:
        static SettingsHolder& GetInstance() NN_NOEXCEPT
        {
            static SettingsHolder inst;
            return inst;
        }

        void LoadStaticConfiguration() NN_NOEXCEPT; // 起動中に変更されないパラメータのロード
        void LoadTransitionBehaviorSettings() NN_NOEXCEPT;
        void LoadSleepReadyBehaviorSettings() NN_NOEXCEPT;
        void LoadFullAwakeBehaviorSettings() NN_NOEXCEPT;
        void LoadSleepModeSettings() NN_NOEXCEPT;

        bool HasBattery() const NN_NOEXCEPT
        {
            return m_HasBattery;
        }

        nn::TimeSpan GetTransitionTimeoutTime() const NN_NOEXCEPT
        {
            return m_TransitionTimeoutTime;
        }

        bool IsEnterSc7DebugSettingEnabled() const NN_NOEXCEPT
        {
            return m_EnterSc7Flag;
        }
        bool IsEnterRealSleepSettingEnabled() const NN_NOEXCEPT
        {
            return m_EnterSleepFlag;
        }
        int GetWakePinDebugMode() const NN_NOEXCEPT
        {
            return m_WakePinDebugMode;
        }

        nn::TimeSpan GetSleepPendingTime() const NN_NOEXCEPT
        {
            return m_SleepPendingTime;
        }

        nn::TimeSpan GetHushTimeAfterBriefPowerButtonPress() const NN_NOEXCEPT
        {
            return m_HushTimeAfterBriefPowerButtonPress;
        }

    private:
        nn::TimeSpan m_TransitionTimeoutTime{ nn::TimeSpan(0) };
        bool m_EnterSc7Flag{ true };
        bool m_EnterSleepFlag{ true };
        int  m_WakePinDebugMode{ 0 };
        nn::TimeSpan m_SleepPendingTime{ nn::TimeSpan(0) };
        nn::TimeSpan m_HushTimeAfterBriefPowerButtonPress{ nn::TimeSpan::FromMilliSeconds(1000) };
        bool m_HasBattery{ true };
    };

}}}

