﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/os/os_MultipleWait.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>

#include "spsm_DebugPowerStateMessageSender.h"

namespace nn { namespace spsm { namespace observer {

//-----------------------------------------------------------------------------
//  初期化
//
void DebugPowerStateMessageSender::Initialize(nn::spsm::server::PowerStateMessageQueue* pPowerStateMessageQueue) NN_NOEXCEPT
{
    m_pPowerStateMessageQueue = pPowerStateMessageQueue;

    os::InitializeTimerEvent(&m_DebugPowerStateMessageSender, os::EventClearMode_AutoClear);
    os::InitializeMultiWaitHolder(&m_DebugPowerStateMessageSenderHolder, &m_DebugPowerStateMessageSender);
    m_DebugPowerStateMessageSenderHolder.userData = reinterpret_cast<uintptr_t>(this);

    int emulationTime = 0;
    settings::fwdbg::GetSettingsItemValue(&emulationTime, sizeof(emulationTime), "systempowerstate", "power_state_message_emulation_trigger_time");

    if ( emulationTime > 0 )
    {
        settings::fwdbg::GetSettingsItemValue(&m_PowerStateMessageToEmulate, sizeof(m_PowerStateMessageToEmulate), "systempowerstate", "power_state_message_to_emulate");
        NN_DETAIL_SPSM_INFO("Message %d will be sent in %d seconds\n", m_PowerStateMessageToEmulate, emulationTime);
        os::StartOneShotTimerEvent(&m_DebugPowerStateMessageSender, nn::TimeSpan::FromSeconds(emulationTime));
    }
}


//-----------------------------------------------------------------------------
//  デストラクタ
//
void DebugPowerStateMessageSender::Finalize() NN_NOEXCEPT
{
    os::FinalizeMultiWaitHolder(&m_DebugPowerStateMessageSenderHolder);
    os::FinalizeTimerEvent(&m_DebugPowerStateMessageSender);
}


//-----------------------------------------------------------------------------
//  DebugPowerStateMessageSender のハンドラ関数（多重待ち解除時に呼ばれる）
//
void DebugPowerStateMessageSender::ProcessDebugPowerStateMessageSender() NN_NOEXCEPT
{
    if (!os::TryWaitTimerEvent(&m_DebugPowerStateMessageSender))
    {
        return;
    }

    NotifyDebugPowerStateMessageSender();
}

//-----------------------------------------------------------------------------

}}} // namespace nn::spsm::observer

