﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.kpr
{
    [CppRefPath(@"<nn/kpr/kpr_KeyCode.h>")]
    [ExternalStruct(4 * 1024, 8)]
    [LargeData(true)]
    public struct KeyCodeMap
    {
    }
}

namespace nn.settings
{
    [CppRefPath(@"<nn/settings/settings_Language.h>")]
    [ExternalStruct(8, 1)]
    public struct LanguageCode
    {
    }

    public interface ISettingsServer : IServiceObject
    {
        [MethodId(0)]
        Result GetLanguageCode(sf.Out<LanguageCode> value);

        [MethodId(1)]
        Result GetAvailableLanguageCodes(
            Out<int32_t> outValue, OutArray<LanguageCode> outCodes);

        [MethodId(2)]
        Result MakeLanguageCode(Out<LanguageCode> outValue, int32_t value);

        [MethodId(3)]
        Result GetAvailableLanguageCodeCount(Out<int32_t> outValue);

        [MethodId(4)]
        Result GetRegionCode(Out<int32_t> outValue);

        [MethodId(5)]
        Result GetAvailableLanguageCodes2(
            Out<int32_t> outValue,
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            OutArray<LanguageCode> outCodes);

        [MethodId(6)]
        Result GetAvailableLanguageCodeCount2(Out<int32_t> outValue);

        [MethodId(7)]
        Result GetKeyCodeMap(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            Out<kpr.KeyCodeMap> outValue);

        [MethodId(8)]
        Result GetQuestFlag(Out<bool> outValue);

        [MethodId(9)]
        Result GetKeyCodeMap2(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            Out<kpr.KeyCodeMap> outValue);
    }
}
