﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_ProductModel.h>

#include "detail/settings_ProductModelImpl.h"

namespace nn { namespace settings { namespace system {

ProductModel GetProductModel() NN_NOEXCEPT
{
    auto value = int32_t();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetProductModel(&value));
    return static_cast<ProductModel>(value);
}

}}} // namespace nn::settings::system
