﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_FirmwareVersion.h>

#include "detail/settings_FirmwareVersionImpl.h"

namespace nn { namespace settings { namespace system {

void GetFirmwareVersion(FirmwareVersion* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetFirmwareVersion(pOutValue));
}

void GetFirmwareVersionDigest(FirmwareVersionDigest* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetFirmwareVersionDigest(pOutValue));
}

void GetRebootlessSystemUpdateVersion(RebootlessSystemUpdateVersion* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetRebootlessSystemUpdateVersion(pOutValue));
}

}}} // namespace nn::settings::system
