﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/factory/settings_DeviceKey.h>
#include <nn/settings/factory/settings_Result.h>

#include "detail/settings_DeviceKeyImpl.h"

namespace nn { namespace settings { namespace factory {

::nn::Result GetEciDeviceKey(EccB233DeviceKey* pOutValue) NN_NOEXCEPT
{
    const ::nn::Result result =
        ::nn::settings::detail::GetEciDeviceKey(pOutValue);

    if (!ResultCalibrationDataFileSystemCorrupted::Includes(result) &&
        !ResultCalibrationDataCrcError::Includes(result))
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

::nn::Result GetEciDeviceKey(Rsa2048DeviceKey* pOutValue) NN_NOEXCEPT
{
    const ::nn::Result result =
        ::nn::settings::detail::GetEciDeviceKey(pOutValue);

    if (!ResultCalibrationDataFileSystemCorrupted::Includes(result) &&
        !ResultCalibrationDataCrcError::Includes(result))
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

::nn::Result GetEticketDeviceKey(Rsa2048DeviceKey* pOutValue) NN_NOEXCEPT
{
    const ::nn::Result result =
        ::nn::settings::detail::GetEticketDeviceKey(pOutValue);

    if (!ResultCalibrationDataFileSystemCorrupted::Includes(result) &&
        !ResultCalibrationDataCrcError::Includes(result))
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

}}} // namespace nn::settings::factory
