﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_IFirmwareDebugSettingsServer.sfdl.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/settings/system/settings_Web.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_Out.h>

#include "settings_FirmwareDebugSettingsServer.h"
#include "settings_SystemSettingsServer.h"
#include "settings_WebImpl.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetWebInspectorFlag(bool* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetWebInspectorFlag(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetWebInspectorFlag(bool value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IFirmwareDebugSettingsServer> pProxy;
    NN_RESULT_DO(CreateFirmwareDebugSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetWebInspectorFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetAllowedSslHosts(
    int32_t* pOutCount,
    ::nn::settings::system::AllowedSslHost outHosts[],
    size_t count) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL(pOutCount);
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    ::nn::sf::OutArray<
        ::nn::settings::system::AllowedSslHost> outArray(outHosts, count);
    NN_RESULT_DO(pProxy->GetAllowedSslHosts(pOutCount, outArray));
    NN_RESULT_SUCCESS;
}

::nn::Result SetAllowedSslHosts(
    const ::nn::settings::system::AllowedSslHost values[],
    size_t count) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IFirmwareDebugSettingsServer> pProxy;
    NN_RESULT_DO(CreateFirmwareDebugSettingsServerProxy(&pProxy));
    ::nn::sf::InArray<
        ::nn::settings::system::AllowedSslHost> inArray(values, count);
    NN_RESULT_DO(pProxy->SetAllowedSslHosts(inArray));
    NN_RESULT_SUCCESS;
}

::nn::Result GetHostFsMountPoint(
    ::nn::settings::system::HostFsMountPoint* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetHostFsMountPoint(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetHostFsMountPoint(
    const ::nn::settings::system::HostFsMountPoint& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IFirmwareDebugSettingsServer> pProxy;
    NN_RESULT_DO(CreateFirmwareDebugSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetHostFsMountPoint(value));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
