﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_IFirmwareDebugSettingsServer.sfdl.h>
#include <nn/settings/settings_ResultPrivate.h>
#include <nn/settings/settings_ServiceTypes.h>
#include <nn/sf/sf_Buffers.h>

#include "settings_FirmwareDebugSettingsServer.h"
#include "settings_SettingsGetterApiImpl.h"
#include "settings_SettingsSetterApiImpl.h"

namespace nn { namespace settings { namespace detail {

::nn::Result SetSettingsItemValue(
    const char* name, const char* key, const void* pValue, size_t valueSize
    ) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(name != nullptr, ResultNullSettingsName());
    NN_RESULT_THROW_UNLESS(key != nullptr, ResultNullSettingsItemKey());
    NN_RESULT_THROW_UNLESS(pValue != nullptr, ResultNullSettingsItemValue());

    ::nn::sf::SharedPointer<IFirmwareDebugSettingsServer> pProxy;
    NN_RESULT_DO(CreateFirmwareDebugSettingsServerProxy(&pProxy));

    SettingsName settingsName = {};
    CopySettingsName(&settingsName, name);

    SettingsItemKey settingsItemKey = {};
    CopySettingsItemKey(&settingsItemKey, key);

    ::nn::sf::InBuffer inBuffer(
        reinterpret_cast<const char*>(pValue), valueSize);
    NN_RESULT_DO(
        pProxy->SetSettingsItemValue(settingsName, settingsItemKey, inBuffer));

    NN_RESULT_SUCCESS;
}

::nn::Result ResetSettingsItemValue(
    const char* name, const char* key) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(name != nullptr, ResultNullSettingsName());
    NN_RESULT_THROW_UNLESS(key != nullptr, ResultNullSettingsItemKey());

    ::nn::sf::SharedPointer<IFirmwareDebugSettingsServer> pProxy;
    NN_RESULT_DO(CreateFirmwareDebugSettingsServerProxy(&pProxy));

    SettingsName settingsName = {};
    CopySettingsName(&settingsName, name);

    SettingsItemKey settingsItemKey = {};
    CopySettingsItemKey(&settingsItemKey, key);

    NN_RESULT_DO(pProxy->ResetSettingsItemValue(settingsName, settingsItemKey));

    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
