﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/settings/system/settings_Network.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_Out.h>

#include "settings_SystemSettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetNetworkSettings(
    int* pOutCount,
    ::nn::settings::system::NetworkSettings* pOutValues,
    int count) NN_NOEXCEPT
{
    // [TODO] Result 値を返すように修正
    NN_ABORT_UNLESS_NOT_NULL(pOutCount);

    auto pProxy = ::nn::sf::SharedPointer<ISystemSettingsServer>();
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    int32_t gotCount = 0;
    ::nn::sf::OutArray<::nn::settings::system::NetworkSettings
                       > outArray(pOutValues, static_cast<size_t>(count));
    NN_RESULT_DO(pProxy->GetNetworkSettings(&gotCount, outArray));

    *pOutCount = gotCount;

    NN_RESULT_SUCCESS;
}

::nn::Result SetNetworkSettings(
    const ::nn::settings::system::NetworkSettings* values,
    int count) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<ISystemSettingsServer>();
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    ::nn::sf::InArray<::nn::settings::system::NetworkSettings
                      > inArray(values, static_cast<size_t>(count));
    NN_RESULT_DO(pProxy->SetNetworkSettings(inArray));

    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
