﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os/os_Mutex.h>

namespace nn { namespace settings { namespace detail {

//!< BasicLockable な MutexType を表す構造体です。
struct LockableMutexType final
{
    ::nn::os::MutexType _mutex;

    void lock() NN_NOEXCEPT
    {
        ::nn::os::LockMutex(&_mutex);
    }

    void unlock() NN_NOEXCEPT
    {
        ::nn::os::UnlockMutex(&_mutex);
    }
};

}}} // namespace nn::settings::detail
