﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/settings/system/settings_Ldn.h>
#include <nn/sf/sf_ISharedObject.h>

#include "settings_LdnImpl.h"
#include "settings_SystemSettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetLdnChannel(int32_t* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetLdnChannel(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetLdnChannel(int32_t value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetLdnChannel(value));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
