﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/kpr/kpr_KeyCode.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_ISettingsServer.sfdl.h>
#include <nn/sf/sf_ISharedObject.h>

#include "settings_SettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetKeyCodeMap(::nn::kpr::KeyCodeMap* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISettingsServer> pProxy;
    NN_RESULT_DO(CreateSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetKeyCodeMap2(pOutValue));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
