﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/kpr/kpr_KeyCode.h>
#include <nn/kpr/detail/kpr_KeyCodeMap.h>
#include <nn/kpr/detail/kpr_KeyCodeMap-layout.ChineseTraditional.h>
#include <nn/kpr/detail/kpr_KeyCodeMap-layout.EnglishUk.h>
#include <nn/kpr/detail/kpr_KeyCodeMap-layout.EnglishUs.h>
#include <nn/kpr/detail/kpr_KeyCodeMap-layout.EnglishUsInternational.h>
#include <nn/kpr/detail/kpr_KeyCodeMap-layout.French.h>
#include <nn/kpr/detail/kpr_KeyCodeMap-layout.FrenchCa.h>
#include <nn/kpr/detail/kpr_KeyCodeMap-layout.German.h>
#include <nn/kpr/detail/kpr_KeyCodeMap-layout.Italian.h>
#include <nn/kpr/detail/kpr_KeyCodeMap-layout.Japanese.h>
#include <nn/kpr/detail/kpr_KeyCodeMap-layout.Korean.h>
#include <nn/kpr/detail/kpr_KeyCodeMap-layout.Portuguese.h>
#include <nn/kpr/detail/kpr_KeyCodeMap-layout.Russian.h>
#include <nn/kpr/detail/kpr_KeyCodeMap-layout.Spanish.h>
#include <nn/kpr/detail/kpr_KeyCodeMap-layout.SpanishLatin.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_Keyboard.h>
#include <nn/settings/settings_ResultPrivate.h>
#include <nn/util/util_TypedStorage.h>

#include "settings_KeyCodeMapDatabase.h"

namespace nn { namespace settings { namespace detail {

namespace {

//!< 文字コード変換表の内部表現を取得します。
const ::nn::kpr::detail::KeyCodeMapStorage& GetKeyCodeMapStorage(
    KeyboardLayout layout) NN_NOEXCEPT
{
    switch (layout)
    {
    case KeyboardLayout_Japanese:
        return ::nn::kpr::detail::KeyCodeMapJapanese;
    case KeyboardLayout_EnglishUs:
        return ::nn::kpr::detail::KeyCodeMapEnglishUs;
    case KeyboardLayout_EnglishUsInternational:
        return ::nn::kpr::detail::KeyCodeMapEnglishUsInternational;
    case KeyboardLayout_EnglishUk:
        return ::nn::kpr::detail::KeyCodeMapEnglishUk;
    case KeyboardLayout_French:
        return ::nn::kpr::detail::KeyCodeMapFrench;
    case KeyboardLayout_FrenchCa:
        return ::nn::kpr::detail::KeyCodeMapFrenchCa;
    case KeyboardLayout_Spanish:
        return ::nn::kpr::detail::KeyCodeMapSpanish;
    case KeyboardLayout_SpanishLatin:
        return ::nn::kpr::detail::KeyCodeMapSpanishLatin;
    case KeyboardLayout_German:
        return ::nn::kpr::detail::KeyCodeMapGerman;
    case KeyboardLayout_Italian:
        return ::nn::kpr::detail::KeyCodeMapItalian;
    case KeyboardLayout_Portuguese:
        return ::nn::kpr::detail::KeyCodeMapPortuguese;
    case KeyboardLayout_Russian:
        return ::nn::kpr::detail::KeyCodeMapRussian;
    case KeyboardLayout_Korean:
        return ::nn::kpr::detail::KeyCodeMapKorean;
    case KeyboardLayout_ChineseSimplified:
        return ::nn::kpr::detail::KeyCodeMapEnglishUs;
    case KeyboardLayout_ChineseTraditional:
        return ::nn::kpr::detail::KeyCodeMapChineseTraditional;
    default: NN_UNEXPECTED_DEFAULT;
    }
}

} // namespace

::nn::Result GetKeyCodeMap(
    ::nn::kpr::KeyCodeMap* pOutValue, KeyboardLayout layout, int port
    ) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(
        pOutValue != nullptr, ResultNullKeyCodeMapBuffer());

    ::nn::kpr::detail::KeyCodeMapStorage&
        storage = ::nn::util::Get(pOutValue->_storage);

    storage = GetKeyCodeMapStorage(layout);

    if (layout == KeyboardLayout_Japanese && port == 1)
    {
        // 本体設定から設定可能になるまではかな入力は常に無効
        storage.attributes.Reset<
            ::nn::kpr::detail::KeyCodeMapAttribute::Hiragana>();
        storage.attributes.Reset<
            ::nn::kpr::detail::KeyCodeMapAttribute::Katakana>();
    }

    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
