﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>

#include "settings_StringBuilder.h"

namespace nn { namespace settings { namespace detail {

//!< bsp0 形式の設定ファイルを扱うクラスです。
class Bsp0SettingsFile final
{
    NN_DISALLOW_COPY(Bsp0SettingsFile);
    NN_DISALLOW_MOVE(Bsp0SettingsFile);

private:
    bool m_IsHeaderFound;       //!< ヘッダが見つかったか否か
    const char* m_Ptr;          //!< 現在位置
    const char* const m_Eof;    //!< 終端位置

public:
    //!< キーの最大バイトサイズ
    static const size_t KeySizeMax = 32;

    //!< 値の最大バイトサイズ
    static const size_t ValueSizeMax = 48;

    Bsp0SettingsFile(const char* buffer, size_t size) NN_NOEXCEPT;

    //!< ファイルの名前を返します。
    static const char* GetName() NN_NOEXCEPT;

    //!< 設定項目をパースします。
    bool ParseItem(StringBuilder<KeySizeMax>* pOutKey,
                   StringBuilder<ValueSizeMax>* pOutValue) NN_NOEXCEPT;
};

//!< bsp0 の設定の名前を返します。
const char* GetBsp0SettingsName() NN_NOEXCEPT;

//!< bsp0 について組み込み設定項目の値のバイト数を取得します。
bool GetBuiltInBsp0SettingsItemValueSize(uint64_t* pOutValue,
                                         const char* name,
                                         const char* key) NN_NOEXCEPT;

//!< bsp0 について組み込み設定項目の値を取得します。
bool GetBuiltInBsp0SettingsItemValue(uint64_t* pOutValue,
                                     char* outBuffer,
                                     size_t outBufferSize,
                                     const char* name,
                                     const char* key) NN_NOEXCEPT;

}}} // namespace nn::settings::detail
