﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/settings/system/settings_BluetoothDevices.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_Out.h>

#include "settings_BluetoothDevicesImpl.h"
#include "settings_SystemSettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetBluetoothDevicesSettings(
    int* pOutCount,
    ::nn::settings::system::BluetoothDevicesSettings outValues[],
    int count) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL(pOutCount);
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    auto outCount = int32_t();
    ::nn::sf::OutArray<
        ::nn::settings::system::BluetoothDevicesSettings>outArray(
            outValues, static_cast<size_t>(count));
    NN_RESULT_DO(pProxy->GetBluetoothDevicesSettings(&outCount, outArray));
    *pOutCount = outCount;
    NN_RESULT_SUCCESS;
}

::nn::Result SetBluetoothDevicesSettings(
    const ::nn::settings::system::BluetoothDevicesSettings values[],
    int count) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    ::nn::sf::InArray<
        ::nn::settings::system::BluetoothDevicesSettings> inArray(
            values, static_cast<size_t>(count));
    NN_RESULT_DO(pProxy->SetBluetoothDevicesSettings(inArray));
    NN_RESULT_SUCCESS;
}

::nn::Result GetBluetoothEnableFlag(bool *pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetBluetoothEnableFlag(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetBluetoothEnableFlag(bool value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetBluetoothEnableFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetBluetoothAfhEnableFlag(bool *pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetBluetoothAfhEnableFlag(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetBluetoothAfhEnableFlag(bool value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetBluetoothAfhEnableFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetBluetoothBoostEnableFlag(bool *pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetBluetoothBoostEnableFlag(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetBluetoothBoostEnableFlag(bool value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetBluetoothBoostEnableFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetBlePairingSettings(
    int* pOutCount,
    ::nn::settings::system::BlePairingSettings outValues[],
    int count) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL(pOutCount);
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    auto outCount = int32_t();
    ::nn::sf::OutArray<
        ::nn::settings::system::BlePairingSettings>outArray(
            outValues, static_cast<size_t>(count));
    NN_RESULT_DO(pProxy->GetBlePairingSettings(&outCount, outArray));
    *pOutCount = outCount;
    NN_RESULT_SUCCESS;
}

::nn::Result SetBlePairingSettings(
    const ::nn::settings::system::BlePairingSettings values[],
    int count) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    ::nn::sf::InArray<
        ::nn::settings::system::BlePairingSettings> inArray(
            values, static_cast<size_t>(count));
    NN_RESULT_DO(pProxy->SetBlePairingSettings(inArray));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
