﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/psm/psm_IPsmManufactureServer.sfdl.h>
#include <nn/psm/psm_ManufactureServiceName.h>
#include <nn/sf/sf_ShimLibraryUtility.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace psm {

namespace {

const int NumberOfClients = 1;

::nn::sf::SimpleAllInOneHipcClientManager<NumberOfClients> g_ClientManager = NN_SF_SIMPLE_ALL_IN_ONE_HIPC_CLIENT_MANAGER_INITIALIZER;

::nn::sf::ShimLibraryObjectHolder<IPsmManufactureServer> g_Holder = NN_SF_SHIM_LIBRARY_OBJECT_HOLDER_INITIALIZER;

} // namespace

void InitializeForManufacture() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_ClientManager.InitializeShimLibraryHolder(&g_Holder, ::nn::psm::ManufactureServiceName));
}

void InitializeForManufactureWith(::nn::sf::SharedPointer<::nn::psm::IPsmManufactureServer>&& server) NN_NOEXCEPT
{
    g_Holder.InitializeHolderDirectly(std::move(server));
}

::nn::sf::SharedPointer<IPsmManufactureServer> GetInternalPsmManufactureServer() NN_NOEXCEPT
{
    return g_Holder.GetObject();
}

void FinalizeForManufacture() NN_NOEXCEPT
{
    g_Holder.FinalizeHolder();
}

void EnableSupplyRouteControl() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_Holder.GetObject()->EnableSupplyRouteControl());
}

void DisableSupplyRouteControl() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_Holder.GetObject()->DisableSupplyRouteControl());
}

void SetSupplyRoute(SupplyRoute supplyRoute) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_Holder.GetObject()->SetSupplyRoute(supplyRoute));
}

}} // namespace nn::psm
