﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/psm/driver/psm_ManufactureApi.h>
#include <nn/psm/psm_ManufactureTypes.h>

#include "detail/psm_PowerSupplyManager.h"

namespace nn { namespace psm { namespace driver {

void EnableSupplyRouteControl() NN_NOEXCEPT
{
    detail::GetPowerSupplyManager().EnableSupplyRouteControl();
}

void DisableSupplyRouteControl() NN_NOEXCEPT
{
    detail::GetPowerSupplyManager().DisableSupplyRouteControl();
}

void SetSupplyRoute(SupplyRoute supplyRoute) NN_NOEXCEPT
{
    detail::GetPowerSupplyManager().SetSupplyRoute(supplyRoute);
}

}}} // namespace nn::psm::driver
