﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

#include <nn/os.h>

#include "psm_IFuelGaugeDriver.h"

namespace nn { namespace psm { namespace driver { namespace detail {

class FuelGaugeDriverStub final : public IFuelGaugeDriver
{
    NN_DISALLOW_COPY(FuelGaugeDriverStub);
    NN_DISALLOW_MOVE(FuelGaugeDriverStub);

public:
    FuelGaugeDriverStub() NN_NOEXCEPT
    {
        // 何もしません。
    }

    virtual ~FuelGaugeDriverStub() NN_NOEXCEPT NN_OVERRIDE
    {
        // 何もしません。
    }

    //! 電池残量計を初期化します。
    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE;

    //! 電池残量計の終了処理をします。
    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;

    //! 電池残量計からの割り込みを有効にします。
    virtual ::nn::Result EnableInterrupt() NN_NOEXCEPT NN_OVERRIDE;

    //! 電池残量計からの割り込みを無効にします。
    virtual ::nn::Result DisableInterrupt() NN_NOEXCEPT NN_OVERRIDE;

    //! 電池温度低下の割り込みを発生させる閾値を設定します。
    virtual ::nn::Result SetLowTemperatureThreshold(int thresholdCelsius) NN_NOEXCEPT NN_OVERRIDE;

    //! 電池温度上昇の割り込みを発生させる閾値を設定します。
    virtual ::nn::Result SetHighTemperatureThreshold(int thresholdCelsius) NN_NOEXCEPT NN_OVERRIDE;

    //! 電池電圧低下の割り込みを発生させる閾値を設定します。
    virtual ::nn::Result SetLowVoltageThreshold(int thresholdMillivolt) NN_NOEXCEPT NN_OVERRIDE;

    //! 電池電圧上昇の割り込みを発生させる閾値を設定します。
    virtual ::nn::Result SetHighVoltageThreshold(int thresholdMillivolt) NN_NOEXCEPT NN_OVERRIDE;

    //! 電池残量低下の割り込みを発生させる閾値を設定します。
    virtual ::nn::Result SetLowChargeThreshold(int thresholdPercentage) NN_NOEXCEPT NN_OVERRIDE;

    //! 電池残量上昇の割り込みを発生させる閾値を設定します。
    virtual ::nn::Result SetHighChargeThreshold(int thresholdPercentage) NN_NOEXCEPT NN_OVERRIDE;

    //! 電池残量低下の割り込みを無効にします。
    virtual ::nn::Result DisableLowChargeInterrupt() NN_NOEXCEPT NN_OVERRIDE;

    //! 電池残量上昇の割り込みを無効にします。
    virtual ::nn::Result DisableHighChargeInterrupt() NN_NOEXCEPT NN_OVERRIDE;

    //! 割込みイベントを取得します。
    virtual ::nn::Result BindInterrupt(::nn::os::SystemEventType* pOutInterruptEvent) NN_NOEXCEPT NN_OVERRIDE;

    //! すべての割り込みをクリアします。
    virtual ::nn::Result ClearInterrupt(::nn::os::SystemEventType* pInterruptEvent) NN_NOEXCEPT NN_OVERRIDE;

    //! 電池温度低下および電池温度上昇の割り込みをクリアします。
    virtual ::nn::Result ClearTemperatureInterrupt() NN_NOEXCEPT NN_OVERRIDE;

    //! 電池電圧低下および電池電圧上昇の割り込みをクリアします。
    virtual ::nn::Result ClearVoltageInterrupt() NN_NOEXCEPT NN_OVERRIDE;

    //! 電池残量低下および電池残量上昇の割り込みをクリアします。
    virtual ::nn::Result ClearChargeInterrupt() NN_NOEXCEPT NN_OVERRIDE;

    //! 電池除去または電池装着の割り込みをクリアします。
    virtual ::nn::Result ClearBatteryInterrupt() NN_NOEXCEPT NN_OVERRIDE;

    //! 電池温度を取得します。
    virtual ::nn::Result GetTemperatureCelsius(double* pTemperature) NN_NOEXCEPT NN_OVERRIDE;

    //! 電池残量計が起動してからの最大電池温度を取得します。
    virtual ::nn::Result GetMaxTemperatureCelsius(int* pOutMaxTemperatureCelsius) NN_NOEXCEPT NN_OVERRIDE;

    //! 電池残量計の状態を取得します。
    virtual ::nn::Result GetStatus(Status* pStatus) NN_NOEXCEPT NN_OVERRIDE;

    //! 電池残量を取得します。
    virtual ::nn::Result GetBatteryChargePercentage(double* pOutValue) NN_NOEXCEPT NN_OVERRIDE;

    //! 電池電圧を取得します。
    virtual ::nn::Result GetBatteryChargeMilliVoltage(int* pOutValue) NN_NOEXCEPT NN_OVERRIDE;

    //! 電池の劣化量を取得します。
    virtual ::nn::Result GetBatteryAgePercentage(double* pOutValue) NN_NOEXCEPT NN_OVERRIDE;

    //! パラメータを保存します。
    virtual ::nn::Result SaveParameter(Parameter* pOutValue) NN_NOEXCEPT NN_OVERRIDE;

    //! パラメータをリストアします。
    virtual ::nn::Result RestoreParameter(const Parameter& parameter) NN_NOEXCEPT NN_OVERRIDE;

    //! パラメータのリストアが必要かを保存します。
    virtual ::nn::Result SetNeedToRestoreParameters(bool needToRestoreParameters) NN_NOEXCEPT NN_OVERRIDE;

    //! パラメータのリストアが必要かを取得します。
    virtual ::nn::Result GetNeedToRestoreParameters(bool* pNeedToRestoreParameters) NN_NOEXCEPT NN_OVERRIDE;

    //! 充放電サイクル数を取得します
    virtual ::nn::Result GetCycles(int* pOutCycles) NN_NOEXCEPT NN_OVERRIDE;

    //! 充放電サイクル数をクリアします。
    virtual ::nn::Result ClearCycles() NN_NOEXCEPT NN_OVERRIDE;

    //! 充電電流を取得します。
    virtual ::nn::Result GetAverageCurrentMilliAmpere(int* pOutValue) NN_NOEXCEPT NN_OVERRIDE;

    //! 電圧残量ゲージによる残量を取得します。
    virtual ::nn::Result GetVoltageFuelGaugePercentage(double* pOutPercentage) NN_NOEXCEPT NN_OVERRIDE;

    //! 評価用に最大容量の生値を取得します。
    virtual ::nn::Result GetFullCapacityMilliAmpereH(int* pOutMilliAmpereH) NN_NOEXCEPT NN_OVERRIDE;

    //! 評価用に現在容量の生値を取得します。
    virtual ::nn::Result GetRemainingCapacityMilliAmpereH(int* pOutMilliAmpereH) NN_NOEXCEPT NN_OVERRIDE;

private:
    //! 割込みイベント
    ::nn::os::SystemEventType m_DummyInterruptEvent;
};

}}}} // namespace nn::psm::driver::detail
