﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/result/result_HandlingUtility.h>

#include "../psm_IUsbPowerManager.h"
#include "psm_UsbPowerDeliveryEventHandler.h"

namespace nn { namespace psm { namespace driver { namespace detail {

UsbPowerDeliveryEventHandler::UsbPowerDeliveryEventHandler() NN_NOEXCEPT
    : m_pUsbPowerManager(nullptr)
    , m_MultiWaitHolder()
    , m_EventForTest()
{
    // 何もしない。
}

UsbPowerDeliveryEventHandler::~UsbPowerDeliveryEventHandler() NN_NOEXCEPT
{
    // 何もしない。
}

void UsbPowerDeliveryEventHandler::Initialize(IUsbPowerManager* pUsbPowerManager) NN_NOEXCEPT
{
    m_pUsbPowerManager = pUsbPowerManager;

    ::nn::os::InitializeEvent(&m_EventForTest, false, ::nn::os::EventClearMode_ManualClear);

    ::nn::os::InitializeMultiWaitHolder(&m_MultiWaitHolder, m_pUsbPowerManager->GetPowerDeliveryNoticeEvent());
}

void UsbPowerDeliveryEventHandler::Finalize() NN_NOEXCEPT
{
    ::nn::os::FinalizeMultiWaitHolder(&m_MultiWaitHolder);

    ::nn::os::FinalizeEvent(&m_EventForTest);
}

void UsbPowerDeliveryEventHandler::LinkMultiWaitHolders(::nn::os::MultiWaitType* pMultiWait) NN_NOEXCEPT
{
    ::nn::os::LinkMultiWaitHolder(pMultiWait, &m_MultiWaitHolder);
}

void UsbPowerDeliveryEventHandler::UnlinkMultiWaitHolders() NN_NOEXCEPT
{
    ::nn::os::UnlinkMultiWaitHolder(&m_MultiWaitHolder);
}

bool UsbPowerDeliveryEventHandler::HandleEvent() NN_NOEXCEPT
{
    if ( ::nn::os::TryWaitSystemEvent(m_pUsbPowerManager->GetPowerDeliveryNoticeEvent()) )
    {
        // 次回の割り込みを受け付けられるように最初にクリア
        ::nn::os::ClearSystemEvent(m_pUsbPowerManager->GetPowerDeliveryNoticeEvent());

        NN_ABORT_UNLESS_RESULT_SUCCESS(m_pUsbPowerManager->ProcessPowerDeliveryNoticeEvent());

        ::nn::os::SignalEvent(&m_EventForTest);

        return true;
    }

    return false;
}

::nn::Result UsbPowerDeliveryEventHandler::GetEventForTest(::nn::os::EventType** pOutEventPointer) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutEventPointer);

    *pOutEventPointer = &m_EventForTest;

    NN_RESULT_SUCCESS;
}

}}}} // namespace nn::psm::driver::detail
