﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/os.h>

#include <nn/srepo/srepo_SystemReport.h>

#include "../psm_IFuelGaugeDriver.h"
#include "psm_EventHandler.h"

namespace nn { namespace psm { namespace driver { namespace detail {

class PeriodicSystemReportSaver final : public EventHandler
{
    NN_DISALLOW_COPY(PeriodicSystemReportSaver);
    NN_DISALLOW_MOVE(PeriodicSystemReportSaver);

public:
    PeriodicSystemReportSaver() NN_NOEXCEPT;
    virtual ~PeriodicSystemReportSaver() NN_NOEXCEPT NN_OVERRIDE;

    void Initialize(IFuelGaugeDriver* pFuelGaugeDriver) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;

    virtual void LinkMultiWaitHolders(::nn::os::MultiWaitType* pMultiWait) NN_NOEXCEPT NN_OVERRIDE;
    virtual void UnlinkMultiWaitHolders() NN_NOEXCEPT NN_OVERRIDE;

    void StartPeriodicTimerEvent() NN_NOEXCEPT;
    void StopTimerEvent() NN_NOEXCEPT;

    virtual bool HandleEvent() NN_NOEXCEPT NN_OVERRIDE;

private:
    void SaveSystemReport() NN_NOEXCEPT;

private:
    IFuelGaugeDriver* m_pFuelGaugeDriver;

    ::nn::os::TimerEventType m_TimerEvent;
    ::nn::os::MultiWaitHolderType m_MultiWaitHolder;

    static const int KeyValueCount = 4; // seconds, cycles, battery_age, max_temperature
    static const size_t BufferSize = ::nn::srepo::SystemReport::BufferSizeMin + ::nn::srepo::KeyValueSizeMax * KeyValueCount;
    uint8_t m_Buffer[BufferSize];
};

}}}} // namespace ::nn::psm::driver::detail
