﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/os.h>

#include "../psm_BatteryChargeManager.h"
#include "../psm_BatteryState.h"
#include "../psm_BatteryVoltageLevelForCharge.h"
#include "../psm_ChargeArbiter.h"
#include "../psm_IChargerDriver.h"
#include "../psm_SessionManager.h"
#include "psm_EventHandler.h"

namespace nn { namespace psm { namespace driver { namespace detail {

class PeriodicStateUpdater final : public EventHandler
{
    NN_DISALLOW_COPY(PeriodicStateUpdater);
    NN_DISALLOW_MOVE(PeriodicStateUpdater);

public:
    PeriodicStateUpdater() NN_NOEXCEPT;

    virtual ~PeriodicStateUpdater() NN_NOEXCEPT NN_OVERRIDE;

    void Initialize(ChargeArbiter* pChargeArbiter, BatteryChargeManager* pBatteryChargeManager, BatteryState* pBatteryState, IChargerDriver* pChargerDriver, SessionManager* pSessionManager) NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    virtual void LinkMultiWaitHolders(::nn::os::MultiWaitType* pMultiWait) NN_NOEXCEPT NN_OVERRIDE;

    virtual void UnlinkMultiWaitHolders() NN_NOEXCEPT NN_OVERRIDE;

    void StartPeriodicTimerEvent() NN_NOEXCEPT;

    void StopTimerEvent() NN_NOEXCEPT;

    virtual bool HandleEvent() NN_NOEXCEPT NN_OVERRIDE;

    ::nn::Result GetPeriodicStateUpdateEventForTest(::nn::os::EventType** pOutEventPointer) NN_NOEXCEPT;

private:
    ::nn::Result ProcessPeriodicStateUpdateEvent() NN_NOEXCEPT;

private:
    ChargeArbiter* m_pChargeArbiter;
    BatteryChargeManager* m_pBatteryChargeManager;
    BatteryState* m_pBatteryState;
    IChargerDriver* m_pChargerDriver;
    SessionManager* m_pSessionManager;

    //! 電池電圧状態
    BatteryVoltageState m_BatteryVoltageState;

    //! 充電設定判断用電池電圧レベル
    BatteryVoltageLevelForCharge m_BatteryVoltageLevelForCharge;

    ::nn::os::TimerEventType m_PeriodicStateUpdateEvent;
    ::nn::os::MultiWaitHolderType m_PeriodicStateUpdateMultiWaitHolder;

    ::nn::os::EventType m_PeriodicStateUpdateEventForTest;
};

}}}} // namespace nn::psm::driver::detail
