﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "../psm_IChargerDriver.h"
#include "../psm_IUsbPowerManager.h"
#include "psm_EventHandler.h"

namespace nn { namespace psm { namespace driver { namespace detail {

//! NX におけるチャージャ関連イベントの処理を行うクラス
class ChargerEventHandler final : public EventHandler
{
    NN_DISALLOW_COPY(ChargerEventHandler);
    NN_DISALLOW_MOVE(ChargerEventHandler);

public:
    ChargerEventHandler() NN_NOEXCEPT;

    virtual ~ChargerEventHandler() NN_NOEXCEPT NN_OVERRIDE;

    void Initialize(IUsbPowerManager* pUsbPowerManager, IChargerDriver* pChargerDriver) NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    virtual void LinkMultiWaitHolders(::nn::os::MultiWaitType* pMultiWait) NN_NOEXCEPT NN_OVERRIDE;

    virtual void UnlinkMultiWaitHolders() NN_NOEXCEPT NN_OVERRIDE;

    virtual bool HandleEvent() NN_NOEXCEPT NN_OVERRIDE;

private:
    ::nn::Result ProcessChargerInterrupt() NN_NOEXCEPT;

private:
    //! USB の電源関連のマネージャーへのポインタ
    IUsbPowerManager* m_pUsbPowerManager;

    //! チャージャドライバへのポインタ
    IChargerDriver* m_pChargerDriver;

    //! チャージャからの割り込みを検出するイベント
    ::nn::os::SystemEventType m_ChargerInterruptEvent;
    ::nn::os::MultiWaitHolderType m_ChargerInterruptMultiWaitHolder;
};

}}}} // namespace nn::psm::driver::detail
