﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.psc
{
    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/psc/psc_PmModuleId.h>")]
    public struct PmModuleId
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/psc/psc_Types.h>")]
    public struct PmState
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/psc/psc_Types.h>")]
    public struct PmFlagSet
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/psc/psc_PmControlTypes.h>")]
    public struct PmControlState
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/psc/psc_PmControlTypes.h>")]
    public struct PmTransitionOrder
    {
    }
}

namespace nn.psc.util
{
    [ExternalStruct(32, 8)]
    [CppRefPath(@"<nn/psc/util/psc_Util.h>")]
    public struct TransitionInformation
    {
    }

    [ExternalStruct(24, 8)]
    [CppRefPath(@"<nn/psc/util/psc_Util.h>")]
    public struct ModuleTransitionInformation
    {
    }

    [ExternalStruct(8, 4)]
    [CppRefPath(@"<nn/psc/util/psc_Util.h>")]
    public struct DependencyInformation
    {
    }
}

namespace nn.psc.sf
{
    [CppRefPath(@"<nn/psc/sfdl/psc.sfdl.h>")]
    public interface IPmControl : IServiceObject
    {
        [MethodId(0)]
        Result Initialize(Out<NativeHandle> handleOut);

        [MethodId(1)]
        Result DispatchRequest(PmState state, PmFlagSet flags, PmTransitionOrder order);

        [MethodId(2)]
        Result GetResult();

        [MethodId(3)]
        Result GetState(Out<PmControlState> state);

        [MethodId(4)]
        Result Cancel();

        [MethodId(5)]
        Result PrintModuleInformation();

        [MethodId(6)]
        Result GetModuleInformation(Out<nn.psc.util.TransitionInformation> transitionInfo, Out<int32_t> moduleCount, nn.sf.OutBuffer moduleInfo, Out<int32_t> dependencyCount, nn.sf.OutBuffer dependencyInfo);
    }

    [CppRefPath(@"<nn/psc/sfdl/psc.sfdl.h>")]
    public interface IPmService : IServiceObject
    {
        [MethodId(0)]
        Result Initialize(Out<IPmModule> pModuleOut);
    }

    [CppRefPath(@"<nn/psc/sfdl/psc.sfdl.h>")]
    public interface IPmModule : IServiceObject
    {
        [MethodId(0)]
        Result Initialize(Out<NativeHandle> handleOut, PmModuleId moduleId, nn.sf.InBuffer childListForSf);

        [MethodId(1)]
        Result GetRequest(Out<PmState> state, Out<PmFlagSet> flags);

        [MethodId(2)]
        Result Acknowledge();

        [MethodId(3)]
        Result Finalize();

        [MethodId(4)]
        Result AcknowledgeEx(PmState state);
    }
}
