﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os/os_Thread.h>
#include <nn/svc/svc_Base.h>

#include "profiler_TargetApplication.h"
#include "profiler_ThreadListItem.h"

namespace nn { namespace profiler {

ThreadListItem::ThreadListItem(nn::os::ThreadId thread) :
    threadType(nullptr),
    threadId(thread),
    priority(0),
    coreMask(0),
    idealCore(0)
{
    memset(threadName, 0, nn::os::ThreadNameLengthMax);
}


ThreadListItem::~ThreadListItem()
{
}


void ThreadListItem::Fill(nn::os::ThreadType* thread)
{
    NN_SDK_ASSERT(threadId == nn::os::GetThreadId(thread));

    threadType = thread;
    SetThreadName(TargetApplication::GetThreadName(thread));
    priority = TargetApplication::GetThreadPriority(thread);
    TargetApplication::GetThreadCoreMask(thread, &idealCore, &coreMask);
}


void ThreadListItem::SetThreadName(const char* name)
{
    if (name != nullptr)
    {
        strncpy(threadName, name, nn::os::ThreadNameLengthMax);
    }
}


}} // nn::profiler
