﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
/*
* Copyright (c) 2016, NVIDIA CORPORATION.  All rights reserved.
*
* NVIDIA CORPORATION and its licensors retain all intellectual property
* and proprietary rights in and to this software, related documentation
* and any modifications thereto.  Any use, reproduction, disclosure or
* distribution of this software and related documentation without an express
* license agreement from NVIDIA CORPORATION is strictly prohibited
*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>


#define NN_PROFILER_MEMORY_MAX_HEAPS 6 // NOLINT(preprocessor/const)


namespace nn { namespace profiler {

typedef uint16_t MemoryHeapHandle;

nn::Result ConnectToMemoryProfiler();
void DisconnectFromMemoryProfiler();
MemoryHeapHandle RegisterMemoryHeap(const char *name);
void BeginMemoryAllocation(MemoryHeapHandle heap);
void BeginMemoryFree(MemoryHeapHandle heap);
void BeginMemoryReallocation(MemoryHeapHandle heap);
void EndMemoryAllocation(MemoryHeapHandle heap, const void *ptr, size_t size);
void EndMemoryFree(MemoryHeapHandle heap, const void *ptr);
void EndMemoryReallocation(MemoryHeapHandle heap, const void *oldptr, const void *newptr, size_t newsize);

void SetMemoryApiLock();

}} // nn::profiler
