﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/profiler/profiler_Types.h>

namespace nn { namespace profiler {

class StringTable;

typedef void(*FinalizeCallback)(void);

void RegisterFinalizeCallbackGraphicsFeatures(FinalizeCallback);

void SetProfilerStatus(ProfilerStatus status);

bool MemoryHeapWasRegistered();

StringTable* GetMarkerNamesStringTable();
uint64_t RegisterStringId(const char* pMarkerName);
void RecordVsync();

}} // nn::profiler
