﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include "profiler_Svc.autogen.h"

namespace nn { namespace profiler {

//struct RewriteAddresses
//{
//    volatile uintptr_t m_WaitVSync;
//    volatile uintptr_t m_RoutingInstrumented;
//};
//extern RewriteAddresses gRewriteAddresses; // defined in profiler_code_rewriting.cpp
//
//
//void SetTrampolineAddresses(uintptr_t* arm);
//void SetSingleTrampolineAddress(uintptr_t arm);
//nn::Result InstrumentFunction(uintptr_t funcAddress, int slot);
//nn::Result InstrumentRemoval(int slot);
//uintptr_t GetFunctionAddrForSlot(int slot);
//
//void SetWaitVSyncAddress(uintptr_t address);
//uintptr_t GetWaitVSyncAddress();
//
//nn::Result RewriteWaitVSyncInitialize();
//nn::Result RewriteWaitVSyncFinalize();
//bool RewriteWaitVSync();
//nn::Result RewriteRoutingInstrumented(bool enable);

namespace /*anonymous*/
{

inline bool IsValidCodeAddress(uintptr_t address)
{
    if (!(address == 0 || address == UINTPTR_MAX))
    {
        nn::svc::MemoryInfo memInfo;
        nn::svc::PageInfo pageInfo;
        nn::Result result = nn::svc::profiler::QueryMemory(&memInfo, &pageInfo, address);
        if (result.IsSuccess())
        {
            return ((memInfo.permission == nn::svc::MemoryPermission_ReadExecute) &&
                (memInfo.state == nn::svc::MemoryState_Code || memInfo.state == nn::svc::MemoryState_AliasCode));
        }
    }
    return false;
}

} // anonymous

} // profiler
} // nn
