﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/prepo/prepo_Api.h>
#include <nn/prepo/prepo_Result.h>
#include <nn/prepo/detail/prepo_ShimLibraryGlobal.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace prepo {

void Initialize() NN_NOEXCEPT
{
    detail::ShimLibraryGlobal::GetInstance().Initialize();
}

nn::Result RequestImmediateTransmission() NN_NOEXCEPT
{
    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    NN_RESULT_DO(session->RequestImmediateTransmission());

    NN_RESULT_SUCCESS;
}

nn::Result GetTransmissionStatus(TransmissionStatus* outStatus) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outStatus);

    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    int32_t status = 0;

    NN_RESULT_DO(session->GetTransmissionStatus(&status));

    *outStatus = static_cast<TransmissionStatus>(status);

    NN_RESULT_SUCCESS;
}

}}
