﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/prepo/detail/service/prepo_Common.h>
#include <nn/prepo/detail/service/util/prepo_Time.h>

namespace nn { namespace prepo { namespace detail { namespace service { namespace util {

namespace
{
    nn::Result posixTimeToString(char* buffer, size_t bufferSize, const nn::time::PosixTime& posixTime) NN_NOEXCEPT
    {
        nn::time::CalendarTime calendar = nn::time::ToCalendarTimeInUtc(posixTime);

        NN_RESULT_THROW_UNLESS(calendar.year <= 9999, ResultInvalidArgument());

        nn::util::SNPrintf(buffer, bufferSize, "%04d-%02d-%02d %02d:%02d:%02d",
            calendar.year, calendar.month, calendar.day,
            calendar.hour, calendar.minute, calendar.second);

        NN_RESULT_SUCCESS;
    }
}

nn::Result GetCurrentUserTimeString(char* buffer, size_t bufferSize) NN_NOEXCEPT
{
    nn::time::PosixTime currentTime;
    NN_RESULT_DO(nn::time::StandardUserSystemClock::GetCurrentTime(&currentTime));

    NN_RESULT_DO(posixTimeToString(buffer, bufferSize, currentTime));

    NN_RESULT_SUCCESS;
}

nn::Result GetCurrentNetworkTimeString(char* buffer, size_t bufferSize) NN_NOEXCEPT
{
    nn::time::PosixTime currentTime;
    NN_RESULT_DO(nn::time::StandardNetworkSystemClock::GetCurrentTime(&currentTime));

    NN_RESULT_DO(posixTimeToString(buffer, bufferSize, currentTime));

    NN_RESULT_SUCCESS;
}

}}}}}
