﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_Base64.h>
#include <nn/prepo/detail/service/core/prepo_ReportBuffer.h>
#include <nn/prepo/detail/service/core/prepo_SystemInfo.h>
#include <nn/prepo/detail/service/core/prepo_SystemReport.h>
#include <nn/prepo/prepo_SystemPlayReport.h>
#include <nn/srepo/srepo_ApiAdmin.h>
#include <nn/srepo/srepo_SystemReport.h>

namespace nn { namespace prepo { namespace detail { namespace service { namespace core {

namespace
{
    ReportCategory FromSrepoCategory(nn::srepo::ReportCategory category) NN_NOEXCEPT
    {
        switch (category)
        {
        case nn::srepo::ReportCategory_Normal:
            return ReportCategory_Normal;
        case nn::srepo::ReportCategory_AntiPiracy:
            return ReportCategory_AntiPiracy;
        default:
            NN_UNEXPECTED_DEFAULT;
        }
    }
}

nn::Result PopAndAddSystemReport() NN_NOEXCEPT
{
    while (NN_STATIC_CONDITION(true))
    {
        nn::srepo::ReportCategory category;
        nn::account::Uid uid;
        char eventId[EventIdLengthMax + 1];
        nn::ApplicationId appId;
        static nn::Bit8 s_Data[nn::srepo::SystemReport::BufferSizeMax];
        size_t dataSize;
        NN_STATIC_ASSERT(nn::srepo::SystemReport::BufferSizeMax <= SystemPlayReport::BufferSizeMax);

        NN_RESULT_TRY(nn::srepo::PopReport(&category, &uid, eventId, &appId, &dataSize, s_Data, sizeof (eventId), sizeof (s_Data)))
            NN_RESULT_CATCH(nn::srepo::ResultBufferEmpty)
            {
                NN_RESULT_SUCCESS;
            }
        NN_RESULT_END_TRY;

        nn::Bit8 sysInfo[detail::service::core::SystemInfo::RequiredBufferSize];
        size_t sysInfoSize = 0;
        NN_RESULT_TRY(SystemInfo::CollectSync(&sysInfoSize, sysInfo, sizeof (sysInfo), appId, eventId, uid))
            NN_RESULT_CATCH_ALL
            {
                continue; // システム情報の収集に失敗したときは読み飛ばす。
            }
        NN_RESULT_END_TRY;

        NN_RESULT_TRY(ReportBuffer::GetInstance().Add(FromSrepoCategory(category), s_Data, dataSize, sysInfo, sysInfoSize))
            NN_RESULT_CATCH(ResultOutOfResource)
            {
                NN_RESULT_SUCCESS; // バッファに空きがないときは中断する。成功扱いにしてハンドリングしない。
            }
        NN_RESULT_END_TRY;
    }
}

}}}}}
