﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/prepo/detail/service/core/prepo_IncrementalId.h>

namespace nn { namespace prepo { namespace detail { namespace service { namespace core {

namespace
{
    const char* FilePath = "prepo-sys:/id.bin";
}

IncrementalId::IncrementalId() NN_NOEXCEPT :
    m_Base(0),
    m_Index(ReserveCount)
{
}

nn::Result IncrementalId::Issue(bool* outIsCommitRequired, uint64_t* outId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outIsCommitRequired);
    NN_SDK_REQUIRES_NOT_NULL(outId);

    NN_UTIL_LOCK_GUARD(m_Mutex);

    if (m_Index == ReserveCount)
    {
        NN_RESULT_DO(ReserveRange());

        *outIsCommitRequired = true;
    }
    else
    {
        *outIsCommitRequired = false;
    }

    *outId = m_Base + m_Index;
    m_Index++;

    NN_RESULT_SUCCESS;
}

nn::Result IncrementalId::ReserveRange() NN_NOEXCEPT
{
    nn::fs::FileHandle handle = {};

    bool isCreateNew = false;

    NN_RESULT_TRY(nn::fs::OpenFile(&handle, FilePath, nn::fs::OpenMode_Read | nn::fs::OpenMode_Write))
        NN_RESULT_CATCH(nn::fs::ResultPathNotFound)
        {
            NN_RESULT_DO(nn::fs::CreateFile(FilePath, 8));
            NN_RESULT_DO(nn::fs::OpenFile(&handle, FilePath, nn::fs::OpenMode_Read | nn::fs::OpenMode_Write));

            isCreateNew = true;
        }
    NN_RESULT_END_TRY;

    NN_UTIL_SCOPE_EXIT
    {
        nn::fs::CloseFile(handle);
    };

    uint64_t currentBase = 0;

    if (!isCreateNew)
    {
        NN_RESULT_DO(nn::fs::ReadFile(handle, 0, &currentBase, 8));
    }

    uint64_t nextBase = currentBase + ReserveCount;

    NN_RESULT_DO(nn::fs::WriteFile(handle, 0, &nextBase, 8, nn::fs::WriteOption::MakeValue(nn::fs::WriteOptionFlag_Flush)));

    m_Base = currentBase;
    m_Index = 0;

    NN_RESULT_SUCCESS;
}

}}}}}
