﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/prepo/detail/service/core/prepo_DebugSettings.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>

namespace nn { namespace prepo { namespace detail { namespace service { namespace core {

namespace
{
    const char* SettingsName = "prepo";

    template <typename T>
    void ReadDebugSettings(const char* key, T* out) NN_NOEXCEPT
    {
        const size_t readSize = sizeof (T);
        NN_ABORT_UNLESS(nn::settings::fwdbg::GetSettingsItemValue(out, readSize, SettingsName, key) == readSize);
    }
}

bool DebugSettings::IsBackgroundProcessingEnabled() NN_NOEXCEPT
{
    bool value;
    ReadDebugSettings("background_processing", &value);
    return value;
}

nn::TimeSpan DebugSettings::GetTransmissionIntervalMin() NN_NOEXCEPT
{
    int32_t value;
    ReadDebugSettings("transmission_interval_min", &value);
    return nn::TimeSpan::FromSeconds(value);
}

nn::TimeSpan DebugSettings::GetTransmissionRetryIntervalMin() NN_NOEXCEPT
{
    int32_t value;
    ReadDebugSettings("transmission_retry_interval_min", &value);
    return nn::TimeSpan::FromSeconds(value);
}

nn::TimeSpan DebugSettings::GetTransmissionRetryIntervalMax() NN_NOEXCEPT
{
    int32_t value;
    ReadDebugSettings("transmission_retry_interval_max", &value);
    return nn::TimeSpan::FromSeconds(value);
}

nn::TimeSpan DebugSettings::GetTransmissionIntervalInSleep() NN_NOEXCEPT
{
    int32_t value;
    ReadDebugSettings("transmission_interval_in_sleep", &value);
    return nn::TimeSpan::FromSeconds(value);
}

bool DebugSettings::IsOutputSaveLogEnabled() NN_NOEXCEPT
{
    bool value;
    ReadDebugSettings("output_save_log", &value);
    return value;
}

nn::TimeSpan DebugSettings::GetStatisticsSaveIntervalMin() NN_NOEXCEPT
{
    int32_t value;
    ReadDebugSettings("statistics_save_interval_min", &value);
    return nn::TimeSpan::FromSeconds(value);
}

nn::TimeSpan DebugSettings::GetStatisticsPostInterval() NN_NOEXCEPT
{
    int32_t value;
    ReadDebugSettings("statistics_post_interval", &value);
    return nn::TimeSpan::FromSeconds(value);
}

}}}}}
