﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "pl_GetSharedFontData-os.win32.h"

namespace nn { namespace pl { namespace srv { namespace detail {

extern const Bit8 StandardFontData[];
extern const Bit8 ChineseSimpleFontData[];
extern const Bit8 ChineseSimpleExtensionFontData[];
extern const Bit8 ChineseTraditionalData[];
extern const Bit8 KoreanFontData[];
extern const Bit8 NintendoExtensionFontData[];
extern const Bit8 NintendoExtension2FontData[];

extern const size_t StandardFontDataLength;
extern const size_t ChineseSimpleFontDataLength;
extern const size_t ChineseSimpleExtensionFontDataLength;
extern const size_t ChineseTraditionalDataLength;
extern const size_t KoreanFontDataLength;
extern const size_t NintendoExtensionFontDataLength;
extern const size_t NintendoExtension2FontDataLength;

const Bit8* GetFontData(pl::SharedFontTypeForSystem fontType) NN_NOEXCEPT
{
    switch( fontType )
    {
    case pl::SharedFontTypeForSystem_Standard:               return StandardFontData;
    case pl::SharedFontTypeForSystem_ChineseSimple:          return ChineseSimpleFontData;
    case pl::SharedFontTypeForSystem_ChineseSimpleExtension: return ChineseSimpleExtensionFontData;
    case pl::SharedFontTypeForSystem_ChineseTraditional:     return ChineseTraditionalData;
    case pl::SharedFontTypeForSystem_Korean:                 return KoreanFontData;
    case pl::SharedFontTypeForSystem_NintendoExtension:      return NintendoExtensionFontData;
    case pl::SharedFontTypeForSystem_NintendoExtension2:     return NintendoExtension2FontData;
    default:                                                 NN_UNEXPECTED_DEFAULT;
    }
}

size_t GetFontSize(pl::SharedFontTypeForSystem fontType) NN_NOEXCEPT
{
    switch( fontType )
    {
    case pl::SharedFontTypeForSystem_Standard:               return StandardFontDataLength;
    case pl::SharedFontTypeForSystem_ChineseSimple:          return ChineseSimpleFontDataLength;
    case pl::SharedFontTypeForSystem_ChineseSimpleExtension: return ChineseSimpleExtensionFontDataLength;
    case pl::SharedFontTypeForSystem_ChineseTraditional:     return ChineseTraditionalDataLength;
    case pl::SharedFontTypeForSystem_Korean:                 return KoreanFontDataLength;
    case pl::SharedFontTypeForSystem_NintendoExtension:      return NintendoExtensionFontDataLength;
    case pl::SharedFontTypeForSystem_NintendoExtension2:     return NintendoExtension2FontDataLength;
    default:                                                 NN_UNEXPECTED_DEFAULT;
    }
}

}}}} // nn::pl::srv
