﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

[AttributeUsage(AttributeTargets.Struct | AttributeTargets.Parameter, AllowMultiple = true)]
class ValidSharedFontTypeAttribute : PreAttribute
{
    public ValidSharedFontTypeAttribute() : base("_ >= 0 && _ < nn::pl::SharedFontType_Max") { }
}

namespace nn.settings
{
    [CppRefPath(@"<nn/settings/settings_Language.h>")]
    [ExternalStruct(8, 8)]
    public struct LanguageCode{}
}

namespace nn.pl.detail
{
    public interface ISharedFontManager : IServiceObject
    {
        [MethodId(0)]
        Result RequestLoad([ValidSharedFontType] int32_t sharedFontType);

        [MethodId(1)]
        Result GetLoadState([ValidSharedFontType] int32_t sharedFontType, Out<int32_t> loadState);

        [MethodId(2)]
        Result GetSize([ValidSharedFontType] int32_t sharedFontType, Out<int32_t> size);

        [MethodId(3)]
        Result GetSharedMemoryAddressOffset([ValidSharedFontType] int32_t sharedFontType, Out<int32_t> offset);

        [MethodId(4)]
        Result GetSharedMemoryNativeHandle(Out<nn.sf.NativeHandle> outHandle);

        [MethodId(5)]
        Result GetSharedFontInOrderOfPriority(Out<bool> outAllFontLoaded, Out<int32_t> outFontCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<int32_t> outTypes, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<int32_t> outOffsets, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<int32_t> outSizes, nn.settings.LanguageCode languageCode);

        [MethodId(6)]
        Result GetSharedFontInOrderOfPriorityForSystem(Out<bool> outAllFontLoaded, Out<int32_t> outFontCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<int32_t> outTypes, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<int32_t> outOffsets, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<int32_t> outSizes, nn.settings.LanguageCode languageCode);
    }
}
